//=====================================================================================
//
//	Author				:Cytron Technologies		
//	Project				:control pwm
//	Project description	:control PWM chip using PIC18F4520 
//
//=====================================================================================

#include<p18f4520.h>

//=====================================================================================
//	configuration bit
//=====================================================================================
#pragma config OSC = HSPLL
#pragma config FCMEN = OFF 
#pragma config IESO = OFF 
#pragma config PWRT = OFF 
#pragma config BOREN = OFF 
#pragma config WDT = OFF 
#pragma config MCLRE = ON	
#pragma config PBADEN = OFF 
#pragma config DEBUG = OFF
#pragma config XINST = OFF
#pragma config LVP = OFF 

//=====================================================================================
//	define input or ouput of board here
//	
//=====================================================================================

#define	button1		PORTBbits.RB0			//button 1 active low
#define	select1		LATBbits.LATB3			//led1 active high				
#define	select2		LATBbits.LATB2			//led2 active high				
#define	select3		LATBbits.LATB1			//led3 active high
#define reset		LATBbits.LATB7			//reset of PWM chip, 0=reset, normally high

//=====================================================================================
//	function prototype
//=====================================================================================
void ISRHigh(void);
void ISRLow(void);
void delay(unsigned long data);
void init(void);

//=====================================================================================
//	Global Variable
//=====================================================================================

//=====================================================================================
//	Main Function
//	This is the main function where program start to execute 
//=====================================================================================

void main(void)
{	

	init();					// call initialization function of the setting in program

	while(1)
	{	
	
		if(button1==0)					//button 1 to switch mode between play and record
		{	
			while(button1==0);			//wait button 1 to release
			reset = 0;
			delay(5000);			//14ms
			reset=1;
			select1 = 0;
			select2 = 0;
			select3 = 0;

		}
	}
	
}

//=====================================================================================
//	functions
//  User can write all the necessary function here
//=====================================================================================

void delay(unsigned long data)
{
	for( ;data>0;data-=1);
}


void init(void)
{

	// this is a initialization for set the input and output of PIC18F4520
	// tris
	TRISB=0x01;				// portB as output, RB0 as input
	TRISD=0x00;				// portD as output
	TRISC=0xff;				// 
	
	select1 = 0;
	select2 = 0;
	select3 = 0;
	
}

//=====================================================================================
//	Interrupt vector
//=====================================================================================
#pragma	code InterruptVectorHigh = 0x08
void InterruptVectorHigh(void)
{
 	_asm
		goto ISRHigh		// jump to interrupt routine
	_endasm
}
#pragma code

#pragma	code InterruptVectorLow = 0x18
void InterruptVectorLow(void)
{
 	_asm
		goto ISRLow			// jump to interrupt routine
	_endasm
}
#pragma code

//=====================================================================================
//	Interupt Service Routine
//	this a function reserved for interrupt service routine
//=====================================================================================
#pragma interrupt ISRHigh
void ISRHigh(void)
{

	
}

#pragma interrupt ISRLow
void ISRLow(void)
{
	
}
